/*
 * Decompiled with CFR 0.152.
 */
package com.compoundtheory.classloader;

import com.compoundtheory.classloader.URLResourceReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NetworkClassLoader
extends ClassLoader {
    private ClassLoader parent = null;
    private Map classCache = new Hashtable();
    private Hashtable urlset = new Hashtable();
    private Set unfoundResources = new HashSet();

    public NetworkClassLoader() {
        super(null);
    }

    public NetworkClassLoader(ClassLoader parent) {
        super(parent);
        this.setParent(parent);
    }

    protected final void setParent(ClassLoader parent) {
        this.parent = parent;
    }

    public synchronized void addURL(URL url) {
        if (!this.urlset.containsKey(url)) {
            try {
                this.urlset.put(url, new URLResourceReader(url));
            }
            catch (IOException ioe) {}
        } else {
            try {
                URLResourceReader newu = new URLResourceReader(url);
                URLResourceReader oldu = (URLResourceReader)this.urlset.get(url);
                oldu.close();
                this.urlset.remove(url);
                this.urlset.put(url, newu);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.unfoundResources.clear();
    }

    public URL[] getURLs() {
        Object[] keys = this.urlset.keySet().toArray();
        URL[] urls = new URL[keys.length];
        System.arraycopy(keys, 0, urls, 0, keys.length);
        return urls;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        byte[] b = this.loadClassData(name);
        if (b != null) {
            return this.defineClass(name, b, 0, b.length);
        }
        throw new ClassNotFoundException(name);
    }

    protected byte[] loadResource(URL url, String resourceName) throws IOException {
        URLResourceReader urr = (URLResourceReader)this.urlset.get(url);
        if (urr != null) {
            return urr.getResource(resourceName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] loadResource(String resource) {
        byte[] barray = null;
        if (this.unfoundResources.contains(resource)) {
            return null;
        }
        Enumeration e = this.urlset.keys();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            try {
                barray = this.loadResource(url, resource);
            }
            catch (Exception ex) {
                if (barray == null) continue;
                break;
            }
            finally {
                if (barray != null) break;
            }
        }
        if (barray == null) {
            this.unfoundResources.add(resource);
        }
        return barray;
    }

    protected byte[] loadClassData(String classname) {
        String resourceName = classname.replace('.', '/') + ".class";
        return this.loadResource(resourceName);
    }

    protected URL findResource(String name) {
        byte[] barray = null;
        if (this.unfoundResources.contains(name)) {
            return null;
        }
        Enumeration e = this.urlset.keys();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            try {
                barray = this.loadResource(url, name);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (barray == null) continue;
            try {
                String ref = url.toString();
                if (ref.endsWith(".jar")) {
                    return new URL("jar:" + ref + "!/" + name);
                }
                return new URL(url, name);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.unfoundResources.add(name);
        return null;
    }

    protected Enumeration findResources(String name) throws IOException {
        if (this.unfoundResources.contains(name)) {
            return new Enumeration(){

                public Object nextElement() {
                    return null;
                }

                public boolean hasMoreElements() {
                    return false;
                }
            };
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        byte[] barray = null;
        Enumeration e = this.urlset.keys();
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            try {
                barray = this.loadResource(url, name);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (barray == null) continue;
            try {
                URL resource;
                String ref = url.toString();
                if (ref.endsWith(".jar")) {
                    resource = new URL("jar:" + ref + "!/" + name);
                    urls.add(resource);
                    continue;
                }
                resource = new URL(url, name);
                urls.add(resource);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (urls.isEmpty()) {
            this.unfoundResources.add(name);
        }
        EnumerationIteratorWrapper enumerator = new EnumerationIteratorWrapper(urls.iterator());
        return enumerator;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream istream = null;
        byte[] data = this.loadResource(name);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        if (this.parent != null && (istream = this.parent.getResourceAsStream(name)) != null) {
            return istream;
        }
        return NetworkClassLoader.getSystemResourceAsStream(name);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] data;
        Class<?> c = null;
        c = (Class<?>)this.classCache.get(name);
        if (c == null && (data = this.loadClassData(name)) != null) {
            c = this.defineClass(name, data, 0, data.length);
            this.classCache.put(name, c);
        }
        if (c == null) {
            c = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public final void clear() {
        this.urlset.clear();
        this.classCache.clear();
        this.unfoundResources.clear();
    }

    protected void finalize() throws Throwable {
        this.clear();
        this.parent = null;
        this.urlset = null;
        this.classCache = null;
        this.unfoundResources = null;
    }

    private class EnumerationIteratorWrapper
    implements Enumeration {
        private Iterator iterator;

        public EnumerationIteratorWrapper(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

